/* $Id: srccalbus.c,v 1.8 1998/07/22 00:16:25 ericb Exp $ */
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen, modified by Eric Backus */

#include <stdio.h>		/* For printf */
#include "e1432.h"

#define	SRC_MAX			5

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "%s: returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "%s: returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

static int
run(void)
{
    E1432ID hw;
    SHORTSIZ16 src_list[SRC_MAX];
    int     i, error, src_group, src_count;
    struct e1432_hwconfig hwconfig;
    SHORTSIZ16 laddr = 8;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());

    /* Use e1432_get_hwconfig to see if the module already has
       firmware.  If this errors, assume we need to install firmware,
       so use e1432_install to do it. */
    error = e1432_get_hwconfig(1, &laddr, &hwconfig);
    CHECK(e1432_print_errors(1));
    if (error != 0)
    {
	(void) printf("loading: /opt/e1432/lib/sema.bin\n");
	CHECK(e1432_install(1, &laddr, 0, "/opt/e1432/lib/sema.bin"));
	CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    }

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    if (hwconfig.source_chans == 0)
    {
	(void) fprintf(stderr, "Error: No source channels found\n");
	return -1;
    }

    /* Create source group */
    src_count = hwconfig.source_chans;
    if (src_count > SRC_MAX)
	src_count = SRC_MAX;
    for (i = 0; i < src_count; i++)
	src_list[i] = E1432_SOURCE_CHAN(i + 1);
    src_group = e1432_create_channel_group(hw, src_count, src_list);
    if (src_group >= 0)
    {
	(void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
		       src_group);
	return -1;
    }

    CHECK(e1432_set_clock_freq(hw, src_group,51200));
    CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
    CHECK(e1432_set_source_mode(hw, src_group, E1432_SOURCE_MODE_SINE));
    CHECK(e1432_set_ramp_rate(hw, src_group, 0));
    CHECK(e1432_set_range(hw, src_group, 1.0));
    CHECK(e1432_set_span(hw, src_group, 625));
    CHECK(e1432_set_amp_scale(hw, src_group, 1.0));

    (void) printf("Connecting source output to VXI SUMBUS\n");

    /* This sends the source signal onto the module's internal CALOUT
       line, and grounds the source output so nothing will be seen on
       the BNC output. */
    CHECK(e1432_set_source_output(hw, src_group,
				  E1432_SOURCE_OUTPUT_GROUNDED));

    /* This sends the module's CALOUT line to the VXI sumbus, which is
       a line on the VXI backplane.  It is pin A32 on the P2 (lower)
       VXI connect - you can hook up a scope and look at the source
       output if you want. */
    CHECK(e1432_set_sumbus(hw, src_group, E1432_SUMBUS_CALOUT));

    /* To also connect the sumbus to the module's CALIN line, which
       connects to any available input channels, use
       e1432_set_calin(E1432_CALIN_SUMBUS).  Then, to tell an input
       channel to look at the CALIN line rather than the normal input
       connector, use e1432_set_input_high(E1432_INPUT_HIGH_CALIN). */

    /* Start measurement */
    (void) printf("Starting measurement\n");
    CHECK(e1432_init_measure(hw, src_group));

    return 0;
}

int
main(void)
{
    if (run() < 0)
	return 2;

    return 0;
}
